Class app

    Shared Sub Main()
        Console.WriteLine("Anwendung gestartet ...")
        Dim Args As String
        Args = "-atheo1 -glovemachine -xsapgw00"
        Dim TheosServer As New RFCServer(Args)

        Console.WriteLine("Registrierung mit: " & Args)
        Console.WriteLine("Folgende Befehle sind mglich:")
        Console.WriteLine("START, STOP, PAUSE, CONTINUE, EXIT")

        Try
            TheosServer.Start()
        Catch ex As Exception
            Console.WriteLine(ex.ToString)
        End Try

        Console.WriteLine("Server gestartet. Warten ...")

        Dim Befehl As String

        Befehl = Console.ReadLine.ToUpper

        Do While Befehl <> "EXIT"
            If Befehl = "STOP" Then
                TheosServer.Stop()
                Console.WriteLine("Server gestoppt ...")
            ElseIf Befehl = "START" Then
                TheosServer.Start()
                Console.WriteLine("Server gestartet ...")
            ElseIf Befehl = "PAUSE" Then
                TheosServer.Pause()
                Console.WriteLine("Server angehalten ...")
            ElseIf Befehl = "CONTINUE" Then
                TheosServer.Continue()
                Console.WriteLine("Server neu gestartet ...")
            Else
                Console.WriteLine("Befehl unbekannt !!")
            End If
            Befehl = Console.ReadLine.ToUpper
        Loop


    End Sub

End Class

<SAP.Connector.RfcStructure(AbapName:="TAB512", Length:=512)> _
Public Class TAB512 : Inherits SAP.Connector.SAPStructure
    Private p_WA As String
    <SAP.connector.RfcField(AbapName:="WA", _
        RfcType:=SAP.Connector.RFCTYPE.RFCTYPE_CHAR, _
        Length:=512, Offset:=0)> _
    Property WA() As String
        Get
            Return p_WA
        End Get
        Set(ByVal Value As String)
            p_WA = Value
        End Set
    End Property
End Class

Public Class TAB512Table : Inherits SAP.Connector.SAPTable
    Shared Function GetElementType() As Type
        Dim smtDelete As New TAB512
        Return smtDelete.GetType

    End Function

    Overrides Function CreateNewRow() As Object
        Return New TAB512
    End Function

    Default Public Property Item(ByVal index As Integer) As TAB512
        Get
            Return List(index)
        End Get
        Set(ByVal Value As TAB512)
            List(index) = Value
        End Set
    End Property

    Public Function Add(ByVal value As TAB512) As Integer
        Return List.Add(value)
    End Function

    Public Sub Insert(ByVal index As Integer, ByVal value As TAB512)
        List.Insert(index, value)
    End Sub

    Public Function IndexOf(ByVal value As TAB512) As Integer
        Return List.IndexOf(value)
    End Function

    Public Function Contains(ByVal value As TAB512) As Boolean
        Return List.Contains(value)
    End Function

    Public Sub Remove(ByVal value As TAB512)
        List.Remove(value)
    End Sub

    Public Sub CopyTo(ByVal array() As TAB512, ByVal index As Integer)
        List.CopyTo(array, index)
    End Sub

End Class

Public Class RFCServer : Inherits SAP.Connector.SAPServer

    Private Druckzeilen(10) As String
    Private WithEvents PrintObject As System.Drawing.Printing.PrintDocument

    Sub New(ByVal ConnectionString As String)
        MyBase.New(ConnectionString)
    End Sub

    <SAP.Connector.RfcMethod(AbapName:="Z_RFC_PRINT")> _
    Protected Sub Z_RFC_PRINT( _
            <SAP.Connector.RfcParameter(AbapName:="PAGECOUNT", _
            RfcType:=SAP.Connector.RFCTYPE.RFCTYPE_INT, _
            Optional:=True, Direction:=SAP.Connector.RFCINOUT.IN)> _
            ByVal PAGECOUNT As Integer, _
            <SAP.Connector.RfcParameter(AbapName:="STATUSMESSAGE", _
            RfcType:=SAP.Connector.RFCTYPE.RFCTYPE_CHAR, _
            Optional:=True, Direction:=SAP.Connector.RFCINOUT.OUT, _
            Length:=100)> _
            ByRef STATUSMESSAGE As String, _
            <SAP.Connector.RfcParameter(AbapName:="PRINTLINES", _
            RfcType:=SAP.Connector.RFCTYPE.RFCTYPE_ITAB, _
            Optional:=True, Direction:=SAP.Connector.RFCINOUT.INOUT, _
            STRUCTURE:="TAB512")> ByRef PRINTLINES As TAB512Table)

        Console.WriteLine("Z_RFC_PRINT aufgerufen ...")

        Dim DruckenMoeglich As Boolean
        Dim x As Long

        For x = 0 To PRINTLINES.Count - 1
            Console.WriteLine("Zeile " & x + 1 & ": " & PRINTLINES(x).WA)
            Druckzeilen(x) = PRINTLINES(x).WA
            If Druckzeilen(x).Trim <> "" Then DruckenMoeglich = True
        Next

        If Not DruckenMoeglich Then
            Dim Fehler As New _
                SAP.connector.RfcAbapException("NO_LINES_TO_PRINT")
            Console.WriteLine("Exception NO_LINES_TO_PRINT ausgelst ...")
            Throw Fehler
        End If

        STATUSMESSAGE = "Druckauftrag zum Drucker gesendet ..."

        PrintObject = New System.Drawing.Printing.PrintDocument
        For x = 1 To PAGECOUNT
            PrintObject.Print()
        Next


        Console.WriteLine("Z_RFC_PRINT abgeschlossen. Warten ....")


    End Sub

    <SAP.Connector.RfcMethod(AbapName:="Z_PING")> _
        Protected Sub Z_PING()

        Console.WriteLine("Z_PING aufgerufen")

    End Sub

    <SAP.Connector.RfcMethod(AbapName:="Z_PING_2")> _
    Protected Sub Z_PING_2(<SAP.Connector.RfcParameter(AbapName:="I_TESTIMPORT", _
             RfcType:=SAP.Connector.RFCTYPE.RFCTYPE_CHAR, _
             Optional:=True, Direction:=SAP.Connector.RFCINOUT.IN, _
             Length:=10)> _
             ByRef I_TESTIMPORT As String)

        Console.WriteLine("Z_PING_2 aufgerufen " & I_TESTIMPORT)

    End Sub

    Private Sub PrintObject_PrintPage(ByVal sender As Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs) Handles PrintObject.PrintPage
        Dim gr As System.Drawing.Graphics = e.Graphics
        Dim fnt As New System.Drawing.Font("Arial", 12)

        Dim x As Long

        For x = 0 To 10
            gr.DrawString(Druckzeilen(x), fnt, _
                System.Drawing.Brushes.Black, e.MarginBounds.X, _
                e.MarginBounds.Y + fnt.Height * x)
        Next

        fnt.Dispose()
    End Sub
End Class